-----------------------------------------------------------------------------------------------
-- address_error_summary.sql
--
-- Show a summary of addresses with errors in the PeopleSoft address table (PS_ADDRESSES)
--
-- History:
--   12/2/2006 Created
--
-- Copyright (c) 2005-2007 Runner Technologies, Inc.  All Rights Reserved.
-- www.RunnerTechnologies.com   sales@RunnerTechnologies.com   877-784-0003  561-395-9322
-----------------------------------------------------------------------------------------------
-- Customer has the right to modify this script so long as original copyright remains
-----------------------------------------------------------------------------------------------

select ca.ADDRESS_ERROR_CODE "Err"
      ,CLEAN_Address_APP.Get_Error_Text(ca.ADDRESS_ERROR_CODE) "Error_Desc"
      ,count(*) "Count"
from   CLN_ADDRESS_APP ca
      ,CLN_ADDRESSES a
where  a.ADDRESS_ID = ca.ID_NUMBER
and    NVL(a.ADDRESS_TYPE_CODE,'x') = NVL(ca.ADDRESS_TYPE(+),'x')
and    a.UPDATED_DATE = ca.EFFECTIVE_DATE(+)
and    ca.FROM_TABLE(+) = 'CLN_ADDRESSES'
group by 
       ca.ADDRESS_ERROR_CODE
      ,CLEAN_Address_APP.Get_Error_Text(ca.ADDRESS_ERROR_CODE);

